"use strict";

window.becli = {

	$active_query: false,
	$timer: false,
	$default_exe_args: {
		ID: null,
		liquid: false,
		pageAttachment: false,
		url: null,
		type: 'json',
		post: null,
		timeout: 30000,
		callBack: null,
		callBack_param: null,
		callBefore: null,
		arrayCallback_param: null,
		background: true,
		expectedHeader: 200,
		donePromises: [],
		sign: true
	},
	cache: {},

	render_item: function( $item, $args ){

		var promise = $.Deferred();

		var endpoint = $item.endpoint;

		window.render.mix( endpoint, $args ).done(function( renderedData ){

			var new_endpoint = renderedData;
			promise.resolve(
				jQuery.extend(
					{
						endpoint: "false"
					},
					$item,
					{
						endpoint: new_endpoint
					}
				)
			);

		})

		return promise;

	},
	render_array: function( $arr, $args ){

		var promise = $.Deferred();
		var promises = [];
		var $new_arr = [];

		for ( var i=0; i<$arr.length; i++ ){
			var arr_item = $arr[ i ];
			var arr_item_promise = $.Deferred();
			window.becli.render_item( arr_item, $args ).done(function( arr_item_rendered ){
				$new_arr.push( arr_item_rendered );
				arr_item_promise.resolve();
			});
			promises.push( arr_item_promise );
		}

		$.when.apply( $, promises ).done(function(){
			promise.resolve( $new_arr );
		});

		return promise;

	},
	exe_array: function( $arr, $args ){

		var promise = $.Deferred();

		if ( !$arr )
		promise.resolve();

		else {

			window.becli.render_array( $arr, $args ).done(function( $renderer_arr ){

				var results = [];
				var promises = [];

				for ( var i=0; i<$renderer_arr.length; i++ ){

					var becli_args = $renderer_arr[ i ];
					var becli_promise = $.Deferred();

					becli_args.expectedHeader = false;
					becli_args.callBack_param = becli_promise;
					becli_args.callBack = function( sta, data, $a ){

						if ( !sta )
						$a.callBack_param.reject();

						else
						$a.callBack_param.resolve({
							args: $a.args,
							result: data
						})

					}

					window.becli.exe( becli_args );
					promises.push( becli_promise );

				}

				$.when.apply( $, promises ).done(function(){

					var results_raw = Array.prototype.slice.call(arguments, 0);
					var results = {};

					for( var i=0; i<results_raw.length; i++ ){
						var result_raw = results_raw[i];
						results[ result_raw.args.key ] = result_raw.result;
					}

					promise.resolve( results );

				}).fail(function(){

					var results_raw = Array.prototype.slice.call(arguments, 0);

					promise.reject();

				});

			});

		}

		return promise;

	},

	exe: function( $args ){

		var promise = $.Deferred();
		var $a = {};
		var $args_default = becli.$default_exe_args;
		$args_default.url = window.config.endpoint_address;
		$args_default.domTarget = $args_default.domTarget == "becli.native_response_handler" ? becli.native_response_handler : $args_default.domTarget;

		for( const[ key, default_value ] of Object.entries( $args_default ) )
		$a[ key ] = $args[ key ] === undefined ? default_value : $args[ key ];

		if ( $a["ID"] ) $a["ID"] = $a["ID"].toString();

		$a["args"] = $args;
		if( !$a['background'] && becli.$active_query ) return;
		if( !$a['background'] ) becli.$active_query = true;
		$a["st"] = window._g._mt();

		if ( $args["endpoint"] )
		$a["url"] = $a["url"] + $args["endpoint"];

		if ( $_bof_config ? $_bof_config.cfc === true : false ){
			var sep = "";
			if ( !$a["url"].includes("?") )
			sep = "?";
			else if ( $a["url"].substr( $a["url"].length-1 ) != "?" )
			sep = "&";
			$a["url"] = $a["url"] + sep + "cfc=" + Date.now();
		}

		var __build = {

			url: $a["url"],
			type: $a["post"] ? "POST" : "GET",
			data: $a["post"],
			timeout: $a["timeout"],
			beforeSend: function( xhr, s ){

				if ( $a.sign )
				window.becli.sign( xhr, s );

				$(document).trigger( "becli_beforeSend" );
				$("body").addClass("becli_loading");

				if ( typeof( $a[ 'domTarget' ] ) == "string" ){

					$("body").find( $a[ 'domTarget' ] )
					.removeClass("success")
					.removeClass("failure")
					.addClass("loading")
					.html( "<div class='text'>Loading</div>" );

				}
				else if ( typeof( $a[ 'domTarget' ] ) == "function" ){
					var $__ID = Math.random().toString(36).substring(7);
					$a['waterMarkIDs'] = [ $__ID ];
					$a[ 'domTarget' ]( "start", null, null, $a )
				}

				// callBefore
				if ( $a["callBefore"] ){

					var callBefore_result = null;
					if ( typeof( $a["callBefore"] ) == "string" ){
						var passedCallBeforeFunction = $a["callBefore"].split(".").reduce( (o, k) => o[k], window );
						if ( typeof( passedCallBeforeFunction ) == "function" )
						callBefore_result = passedCallBeforeFunction( $a )
					}
					else
					callBefore_result = $a["callBefore"]( $a )

					if ( callBefore_result == "BOF_HALT" )
					xhr.abort();

				}

			},
			success: function( data, status, responseData ){
				$a["dt"] = window._g._pt( $a["st"] );
				becli.check_response( $a, status, responseData, promise );
				if ( window.apk ){
					window.apk.becli.after( $a, status, responseData, promise )
				}
			},
			error: function( responseData, status, err ){

				$a["dt"] = window._g._pt( $a["st"] );

				if ( status != "abort" ){
					console.log( responseData );
					console.log( status );
					console.log( err );
				}

				becli.check_response( $a, status, responseData, promise, err );
				if ( window.apk ){
					window.apk.becli.after( $a, status, responseData, promise, err )
				}

			},

		};

		if ( $a["type"] == "file" ){
			__build['contentType'] = false;
			__build['processData'] = false;
		}
		else if ( $a["type"] == "json" ){
			__build['dataType'] = 'json';
		}
		else {
			__build['dataType'] = 'html';
		}

		if ( window.config.platform != "web" ){
			if ( window.apk.becli.before( __build, $args, $a, promise ) === "HALT" ){
				return;
			}
		}

		var xhr_client = $.ajax( __build );

		if ( $a["ID"] ){
			if ( Object.keys( window.becli.cache ).includes( $a["ID"] ) ){
				window.becli.cache[ $a["ID"] ].abort();
				window.becli.cache[ $a["ID"] ] = null;
			}
			window.becli.cache[ $a["ID"] ] = xhr_client;
		}
		if ( $a["liquid"] !== true ){
			window.ui.page.cache.becli.push( xhr_client );
		}

		return {
			client: xhr_client,
			promise: promise,
			build: __build,
			args: $a
		}

	},
	check_response: function ( $a, status, responseData, promise, err ){

		$("body").removeClass("becli_loading");
		if( !$a['background'] ) becli.$active_query = false;

		if ( $a["ID"] ? Object.keys( window.becli.cache ).includes( $a["ID"] ) : false )
		delete window.becli.cache[ $a["ID"] ]

		var sta  = ( status == "success" || ( status == "error" && err == "Not Found" ) ) && ( $a["expectedHeader"] ? responseData.status == $a["expectedHeader"] : true );
		var data = responseData.responseText ? responseData.responseText : "Failed";

		// JSON Data
		if ( $a["type"] == "json" || $a["type"] == "file" ){

			var decoded = null;
			try {
				decoded = JSON.parse( data );
			} catch( e ){
				decoded = false;
			}

			if ( !decoded ){
				if ( err == "abort" ){
					promise.reject( "aobrt" );
					window.becli.callback( $a["callBack"], $a, sta, { messages: [ "Aborted" ], aborted: true } );
					return;
				}
				else {
					promise.reject( "not_json" );
					window.becli.callback( $a["callBack"], $a, false, { messages: [ "Invalid Json" ] } );
					return;
				}
			}

			sta = sta ? decoded["success"] : false;
			data = decoded;

		  if ( !sta ? ( decoded["messages"] ? decoded["messages"][0] == "403" : false ) : false ){
			window.user.setLoginDestination( window.location.href );
			window.user.loggedOut( true );
		  }

		}

		if ( sta )
		promise.resolve({
			data: data,
			args: $a
		});
		else
		promise.reject( data[0] ? data[0] : err, sta, data );

		window.bof.log( "BECLI: " + $a.url + " ==> " + ( sta ? "Success" : "Failure" ) + " in " + $a.dt, 4, { css: sta ? 'color:#aaa' : 'color:red' } );
		if ( !sta ){
			console.log( $a, status, responseData, err );
		}

		if ( typeof( $a["domTarget"] ) == "string" ){

			$("body").find( $a[ 'domTarget' ] )
				.removeClass("success")
				.removeClass("failure")
				.removeClass("loading")
				.html( "<div class='text'>"+data+"</div>" );

			if ( sta ) $("body").find( $a[ 'domTarget' ] ).addClass("success");
			else $("body").find( $a[ 'domTarget' ] ).addClass("failure");

		}
		else if ( typeof( $a["domTarget"] ) == "function" ){
			$a["domTarget"]( "finish", sta, data, $a );
		}

		// Callback
		if ( $a["callBack"] ){
			window.becli.callback( $a["callBack"], $a, sta, data );
		}

		

	},
	callback: function( $_callback, $a, sta, data ){

		var $continue = null;
		if ( typeof( $_callback ) == "string" ){
			var passedCallBackFunction = $_callback.split(".").reduce( (o, k) => o[k], window );
			if ( typeof( passedCallBackFunction ) == "function" ){
				$continue = passedCallBackFunction( sta, data, $a );
			}
		}
		else if ( typeof $_callback == 'function' )
		$continue = $_callback( sta, data, $a );
		else {
			console.log( "BECLI: invalid callback" );
			console.log( $_callback );
		}

	},
	sign: function( xhr, s ){

		var CryptoJSAesJson = {
			stringify: function (cipherParams) {

				var cipherText = cipherParams.ciphertext.toString( CryptoJS.enc.Base64 );
				var cipherIV = cipherParams.iv.toString();
				var cipherSalt = cipherParams.salt.toString();
				return {
					text: cipherText,
					iv: cipherIV,
					salt: cipherSalt
				}

			},
		}

		if ( s ? s.data && s.processData : false ){
			var l1 = CryptoJS.HmacSHA256( s.data, $_bof_config.sign_key );
			var l2 = CryptoJS.MD5( l1.toString() );
			s.data = s.data + "&bof_signature=" + l2.toString();
		}

		xhr.setRequestHeader( 'x-bof-request-code', 'BusyOwlFrameWorkVersion201' );
		xhr.setRequestHeader( 'x-bof-platform', window.config.platform );
		xhr.setRequestHeader( 'x-bof-version', window.config.version );

		try {

			if ( window.ui.page.curr().name )
			xhr.setRequestHeader( 'x-bof-page-name', window.ui.page.curr().name );

			if ( window.ui.page.curr().data.becli ? ( window.ui.page.curr().data.becli.single ? window.ui.page.curr().data.becli.single.data : false ) : false )
			xhr.setRequestHeader( 'x-bof-page-ot', window.ui.page.curr().data.becli.single.data.ot );

			if ( window.ui.page.curr().data.becli ? ( window.ui.page.curr().data.becli.single ? window.ui.page.curr().data.becli.single.data : false ) : false )
			xhr.setRequestHeader( 'x-bof-page-hash', window.ui.page.curr().data.becli.single.data.hash );

		} catch( error ){}

		if ( window.config.platform != "web" ){
			xhr.setRequestHeader( 'x-bof-device-cordova', device.cordova );
			xhr.setRequestHeader( 'x-bof-device-model', device.model );
			xhr.setRequestHeader( 'x-bof-device-platform', device.platform );
			xhr.setRequestHeader( 'x-bof-device-uuid', device.uuid );
			xhr.setRequestHeader( 'x-bof-device-version', device.version );
			xhr.setRequestHeader( 'x-bof-device-manufacturer', device.manufacturer );
			xhr.setRequestHeader( 'x-bof-device-is-virtual', device.isVirtual );
			xhr.setRequestHeader( 'x-bof-device-serial', device.serial );
		}

		if ( window.user.logged() ){
			xhr.setRequestHeader( 'x-bof-sess-id', cache.get( "sess_id" ) );
			xhr.setRequestHeader( 'x-bof-sess-key', cache.get( "sess_key" ) );
		}

		if ( window.cache.get( "push_id" ) )
		xhr.setRequestHeader( 'x-bof-push-id', window.cache.get( "push_id" ) );

		if ( window.cache.get( "ref_code" ) )
		xhr.setRequestHeader( 'x-bof-ref-code', window.cache.get( "ref_code" ) );

		if ( window.cache.get( "language" ) )
		xhr.setRequestHeader( 'x-bof-language-code', window.cache.get( "language" ) );

	}

}

$(document).on( "submit", "form.bof", function(e){

	e.preventDefault();

	var $__url      = $(this).data("url") ? $(this).data("url") : undefined;
	var $__hasFile  = $(this).data("hasFile") ? true : false;
	var $__type     = $(this).data("type") ? $(this).data("type") : "json";
	var $__target   = $(this).data("target");
	var $__endpoint = $(this).data("endpoint");
	var $__callback = $(this).data("callback");
	var $__callback_param = $(this).data("callback_param");
	var $__callbefore = $(this).data("callbefore");
	var $__formData = null;

	if ( $__type == "file" ){
		$__formData = new FormData( this );
	} else {
		$__formData = $(this).serialize();
	}

	becli.exe({
		url: $__url,
		type: $__type,
		post: $__formData,
		callBack: $__callback,
		callBack_param: $__callback_param,
		callBefore: $__callbefore,
		domTarget: $__target,
		hasFile: $__hasFile,
		endpoint: $__endpoint,
		background: false
	});

});
