"use strict";

window.bof_upload = {

  cache: {},
  ready: function(){

    $(document).find("#uploader .step1").addClass( "c_" + $(document).find("#uploader .step1 .step_i").length )

    var pageData = window.ui.page.curr().data.becli.upload;
    window.bof_upload.cache.c_types = pageData._cs;
    window.bof_upload.cache.s_types = pageData._ss;

    window.bof_upload.functions.set_step( 1 );

    $(document).on("click","#uploader .step1 .step_i",function(e){

      if ( window.bof_upload.cache.step != 1 ) return;
      var hook = $(this).data("hook");
      if ( Object.keys( window.bof_upload.cache.c_types ).includes( hook ) == false ) return;
      var content = window.bof_upload.cache.c_types[ hook ];
      window.bof_upload.cache.content = content;

      if ( content["step1.5"] ){
        window.bof_upload.functions.set_step( 1.5 );
      }
      else
      window.bof_upload.functions.set_step( 2 );

    });
    $(document).on("click","#uploader .step1_5 .step_i",function(e){

      if ( window.bof_upload.cache.step != 1.5 ) return;

      var hook = $(this).data("hook");
      if ( Object.keys( window.bof_upload.cache.content["step1.5"] ).includes( hook ) == false )
      return;

      window.bof_upload.cache["step1.5"] = hook;
      window.bof_upload.functions.set_step( 2 );

    });
    $(document).on("click","#uploader .step2 .step_i",function(e){
      if ( window.bof_upload.cache.step != 2 ) return;
      var hook = $(this).data("hook");
      if ( Object.keys( window.bof_upload.cache.s_types ).includes( hook ) == false ) return;
      if ( window.bof_upload.cache.content.sources.supported.includes( hook ) == false ) return;

      window.bof_upload.cache.source = window.bof_upload.cache.s_types[ hook ];

      if ( window.bof_upload.cache.content.sources.data[ hook ] )
      window.bof_upload.cache.source.upload = $.extend(
        window.bof_upload.cache.source.upload,
        window.bof_upload.cache.content.sources.data[ hook ]
      );

      window.bof_upload.functions.set_step( 3 );

    });
    $(document).on("click","#uploader .step.source_dom .uploader_mask .sub_text ._rules",function(e){
      $(document).find("#uploader .step.source_dom .uploader_mask").toggleClass("show_tip");
    });
    $(document).on("click","#uploader .step.source_dom .uploader_mask.file.show_tip .tip",function(e){
      $(document).find("#uploader .step.source_dom .uploader_mask").removeClass("show_tip");
    });
    $(document).on("click","#uploader .step.step3 .continue .btn",function(e){
      window.bof_upload.functions.set_step( 4 );
    });
    $(document).on("click","#uploader .step.step4_5 .continue .btn",function(e){

      var _t = $(this);
      var formData = $(document).find("#uploader .step4_5 form").serializeArray();
      var dataObject = {
        content_data: JSON.stringify( window.bof_upload.cache.content.data ),
        source_data: JSON.stringify( window.bof_upload.cache.source.data ),
        verified: JSON.stringify( window.bof_upload.cache.verified ),
        step1_5: window.bof_upload.cache["step1.5"]
      };
      if ( formData ){
        for ( var i=0; i<formData.length; i++ ){
          var formInput = formData[i];
          dataObject[ formInput.name ] = formInput.value;
        }
      }

      window.app.becli.exe( "button", {
        dom: _t,
      }, {
        endpoint: "user_upload_verify_group",
        post: dataObject,
        c_callback: function( sta, data ){
          if ( sta ){
            window.bof_upload.cache.verified = data.verified;
            window.bof_upload.functions.set_step( 5 );
            window.bof_upload.cache.group_data = data["data"];
          }
        },
        reload_after: false
      })

    });
    $(document).on("click","#uploader .step.step5 .form_wrapper .groups_wrapper .group",function(e){

      var code = $(this).attr("data-code");
      var form = $(this).parents(".form_wrapper");

      form.find(".groups_wrapper .group.active").removeClass("active");
      $(this).addClass("active");
      form.find(".setting_wrapper").addClass("hideByGroup");
      form.find(".setting_wrapper.group_all").removeClass("hideByGroup");
      form.find(".setting_wrapper.group_"+code).removeClass("hideByGroup")

    });
    $(document).on("change","#uploader .step.step5 .form_wrapper .bof_input", function(e){
      window.bof_upload.functions.exe_rules( $(this).parents(".form_wrapper") );
    });
    $(document).on("click","#uploader .step.step5 .form_wrapper .continue .btn",function(e){

      var _t = $(this);

      var formData = $(this).parents(".form_wrapper").find("form").serializeArray();

      var dataObject = {
        content_data: JSON.stringify( window.bof_upload.cache.content.data ),
        source_data: JSON.stringify( window.bof_upload.cache.source.data ),
        group_data: JSON.stringify( window.bof_upload.cache.group_data ),
        step1_5: window.bof_upload.cache["step1.5"]
      };

      if ( Object.keys(window.bof_upload.cache.content["step1.5"])[0] == window.bof_upload.cache["step1.5"] ){
        var groupFormData = $(document).find("#uploader .step4_5 form").serializeArray();
        if ( groupFormData ){
          for ( var i=0; i<groupFormData.length; i++ ){
            var formInput = groupFormData[i];
            dataObject[ "group_" + formInput.name ] = formInput.value;
          }
        }
      }

      if ( formData ){
        for ( var i=0; i<formData.length; i++ ){
          var formInput = formData[i];
          dataObject[ formInput.name ] = formInput.value;
        }
      }

      dataObject["source_id"] = _t.data("form-id");
      for ( var i=0; i<window.bof_upload.cache.verified.length; i++ ){
        var _v = window.bof_upload.cache.verified[i];
        if ( _v.ID == _t.data("form-id") )
        dataObject["verified_source"] = JSON.stringify( _v.data );
      }

      window.app.becli.exe( "button", {
        dom: _t,
      }, {
        endpoint: "user_upload_submit",
        post: dataObject,
        c_callback: function( sta, data ){
          if ( sta ){
            $(document).find(".form_wrapper[data-id='"+(dataObject.source_id)+"']").remove();
            if ( $(document).find(".step.step5 .form_wrapper").length == 0 ){
              window.ui.link.navigate( "user_library?tab=uploads" )
            }
          }
        },
        reload_after: false
      })

    });

    // window.ui.body.addClass( "no_footer" );

  },
  unloading: function(){

    window.bof_upload.cache = {};
    $(document).off("click","#uploader .step1 .step_i");
    $(document).off("click","#uploader .step1_5 .step_i");
    $(document).off("click","#uploader .step2 .step_i");
    $(document).off("click","#uploader .step.source_dom .uploader_mask .sub_text ._rules");
    $(document).off("click","#uploader .step.source_dom .uploader_mask.file.show_tip .tip");
    $(document).off("click","#uploader .step.step3 .continue .btn");
    $(document).off("click","#uploader .step.step4_5 .continue .btn");
    $(document).off("click","#uploader .step.step5 .form_wrapper .groups_wrapper .group");
    $(document).off("change","#uploader .step.step5 .form_wrapper .bof_input");
    $(document).off("click","#uploader .step.step5 .form_wrapper .continue .btn");

    window.ui.lock.off("upload_inputs");
    window.ui.lock.off("upload_source");
    window.ui.lock.off("upload_step_4");

    // if ( window.app.config.setting.additional_body_classes ? !window.app.config.setting.additional_body_classes.includes( "no_sidebar" ) : true )
    // window.ui.body.removeClass( "no_sidebar", true );

  },
  functions: {
    set_step: function( $val ){

      window.bof_upload.cache.step = $val;

      $(document).find("#uploader").removeClass("step1 step1.5 step2 step3 step4 step5").addClass("step"+$val);
      $(document).find("#uploader .step").addClass("inactive").removeClass("active");
      $(document).find("#uploader .step.step"+($val.toString().replace(".","_"))).addClass("active").removeClass("inactive");

      if ( $val > 1.5 )
      $(document).find("#uploader .steps .p.active").removeClass("active").addClass("done");

      $(document).find("#uploader .steps .p.p"+($val.toString().replace(".","_"))).addClass("active").removeClass("done");

      if ( $val == 1.5 || $val == 2 ){
        if ( window.bof_upload.cache.content.data.step5 ){
          $(document).find("#uploader .steps .p.p5").removeClass("disabled").find(".title").text( window.bof_upload.cache.content.data.step5 )
        }
      }

      if ( $val == 1.5 ){

        var html = "";
        var options = window.bof_upload.cache.content["step1.5"];
        for ( var i=0; i<Object.keys(options).length; i++ ){

          var option_k = Object.keys(options)[i];
          var option_v = options[ option_k ];

          html += "<div class='step_i' data-hook='"+option_k+"'>\
            <span class='mdi mdi-"+option_v["icon"]+"'></span>\
            <span class='name'>"+option_v["title"]+"</span>\
          </div>";

        }

        $(document).find("#uploader .step_c2").html( html );

      }
      else if ( $val == 2 ){

        $(document).find("#uploader .wrapper > .title").text( window.ui.page.curr().data.becli.upload._ts[2] );

        if ( window.bof_upload.cache.content.data.step4_5 ){
          if ( Object.keys(window.bof_upload.cache.content["step1.5"])[0] == window.bof_upload.cache["step1.5"] ){
            $(document).find("#uploader .steps .p.p4_5").removeClass("disabled").find(".title").text( window.bof_upload.cache.content.data.step4_5 )
            $(document).find("#uploader .steps .p.p5 .mask").text("5")
          }
        }

        var supported = window.bof_upload.cache.content.sources.supported;
        $(document).find("#uploader .step.step2 .step_i").removeClass("active").addClass("inactive");
        $(document).find("#uploader .step2").removeClass("c_1 c_2 c_3 c_4 c_5 c_6").addClass( "c_" + supported.length )
        for ( var i=0; i<supported.length; i++ ){
          $(document).find("#uploader .step.step2 .step_i.s_"+supported[i]).addClass("active").removeClass("inactive");
        }

      }
      else if ( $val == 3 ){

        var source_object = window.bof_upload.cache.source.upload;

        var promiseToRenderInputs = $.Deferred();
        window.ui.lock.on("upload_inputs");

        if ( source_object.inputs ){

          $(document).find("#uploader .wrapper > .title").text( window.ui.page.curr().data.becli.upload._ts["3i"] );
          $(document).find("#uploader").removeClass("s3i s3u").addClass("s3i");

          var promiseToRenderAllArray = [];
          for ( var i=0; i<Object.keys(source_object.inputs).length; i++ ){

            var _key = Object.keys(source_object.inputs)[i];
            var _input = source_object.inputs[ _key ];

            var promiseToRenderInput = $.Deferred();
            promiseToRenderAllArray.push( promiseToRenderInput );

            window.ui.theme.part( "parts/o_input", { target: false, dir: "theme", base: $_bof_config.assets_address } ).done(function( html ){
              window.render.mix( html, _input.input ).done(function( renderred ){
                promiseToRenderInput.resolve( "<div class='input_wrapper type_"+_input.input.type+"'><div class='title'>"+ _input.title +"</div><div class='the_input'>" + renderred + "</div>" + ( _input.tip ? "<div class='tip'>" + _input.tip + "</div>" : "" ) + "</div>" );
              } );
            } );

          }

          $.when.apply( $, promiseToRenderAllArray ).done( function(){
            var inputs_renderred = Array.prototype.slice.call( arguments, 0 );
            promiseToRenderInputs.resolve( inputs_renderred.join( "" ) );
          } );

        }
        else {
          promiseToRenderInputs.resolve();
        }

        promiseToRenderInputs.done(function(html){

          window.ui.lock.off("upload_inputs");
          $(document).find("#uploader .source_dom").removeClass("type_upload");

          if ( source_object.type ){
            window.ui.lock.on("upload_source");
            $(document).find("#uploader .source_dom").addClass("type_"+source_object.type);
            if ( source_object.type == "upload" ){
              $(document).find("#uploader .wrapper > .title").text( window.ui.page.curr().data.becli.upload._ts["3u"] );
              $(document).find("#uploader").removeClass("s3i s3u").addClass("s3u");
              window.bof_upload.functions.dropzone_setup();
            }
          }
          else {
            $(document).find("#uploader .source_dom").html( "<div class='form_wrapper'>\
                <form><div class='inputs_wrapper'>" + html + "</div></form>\
              <div class='continue'><div class='btn btn-primary'>"+window.lang.return( "continue", { ucfirst: true } )+"</div></div>\
            </div>" );
          }

        });

      }
      else if ( $val == 4 ){

        var source_object = window.bof_upload.cache.source.upload;
        var content = window.bof_upload.cache.content;

        var given_data = {
          files: [],
          inputs: {}
        };

        var content_inputs = content.inputs;

        if ( source_object.type == "upload" ){
          if ( window.bof_input.cache.dropzones ? ( window.bof_input.cache.dropzones[0] ? window.bof_input.cache.dropzones[0].files : false ) : false ){
            var files = window.bof_input.cache.dropzones[0].files;
            for ( var i=0; i<files.length; i++ ){
              var file = files[i];
              if ( file.status != "success" ) continue;
              var file_xhr = file.xhr.responseText;
              var data = JSON.parse( file_xhr );
              if ( !data ? true : !data.success ) continue;
              given_data.files.push( data );
            }
          }
        }
        else {
          var inputs = source_object.inputs;
          if ( inputs ){
            for( var i=0; i<Object.keys(inputs).length; i++ ){
              var __key = Object.keys(inputs)[i];
              var input = inputs[ __key ].input;
              var input_name = input.name;
              var input_value = window.bof_input.get_input( input );
              given_data.inputs[ input_name ] = input_value;
            }
          }
        }

        window.ui.lock.on("upload_step_4");

        var load_daterangepicker = window.bof_input.load_daterangepicker();

        window.becli.exe({
          endpoint: "user_upload_verify_sources",
          post: {
            given_data: JSON.stringify( given_data ),
            content_data: JSON.stringify( window.bof_upload.cache.content.data ),
            source_data: JSON.stringify( window.bof_upload.cache.source.data ),
            step1_5: window.bof_upload.cache["step1.5"]
          },
          callBack: function( sta, data ){

            if ( sta ){

              window.bof_upload.cache["verified"] = Object.values( data["verified"] )

              if ( data["step4_5"] ){

                var promiseToRenderInputs = [];
                for ( var i=0; i<Object.keys(data["step4_5"]).length; i++ ){

                  var promiseToRenderInput = $.Deferred();
                  promiseToRenderInputs.push( promiseToRenderInput );

                  var _ik = Object.keys(data["step4_5"])[i];
                  var _input = data["step4_5"][ _ik ];

                  window.ui.theme.part( "parts/o_input", { target: false, dir: "theme", base: $_bof_config.assets_address } ).done(function( html ){
                    window.render.mix( html, _input.input ).done(function( renderred ){
                      promiseToRenderInput.resolve( "<div class='input_wrapper type_"+_input.input.type+" setting_wrapper' ID='item_"+_input.input.name+"'><div class='title'>"+ _input.label +"</div><div class='the_input'>" + renderred + "</div>" + ( _input.tip ? "<div class='tip'>" + _input.tip + "</div>" : "" ) + "</div>" );
                    } );
                  } );

                }

                $.when.apply( $, promiseToRenderInputs ).done(function(){

                  var inputs_renderred = Array.prototype.slice.call( arguments, 0 );
                  $(document).find("#uploader .step4_5").html( "<div class='form_wrapper uef'><form><div class='inputs_wrapper'>"+ inputs_renderred.join("") + "</div></form>" +
                  "<div class='continue'><div class='btn btn-primary'>"+window.lang.return( "continue", { ucfirst: true } )+"</div></div></div>" );
                  load_daterangepicker.done(function(){
                    window.ui.lock.off("upload_step_4");
                    window.bof_upload.functions.set_step( 4.5 );
                  });

                });

              }
              else {

                load_daterangepicker.done(function(){
                  window.ui.lock.off("upload_step_4");
                  window.bof_upload.functions.set_step( 5 );
                });

              }

            }
            else {
              window.ui.lock.off("upload_step_4");
              window.bof_upload.functions.set_step( 3 );
              window.app.becli.alert( false, data.messages[0] );
            }

          }
        })

      }
      else if ( $val == 4.5 ) {
        window.bof_input.hook_daterangepicker();
        $(document).find("#uploader .wrapper > .title").text( window.bof_upload.cache.content.data.step4_5 );
      }
      else if ( $val == 5 ){

        $(document).find("#uploader .wrapper > .title").text( window.bof_upload.cache.content.data.step5 );
        if ( window.bof_upload.cache.content.data.step4_5 ){
          if ( Object.keys(window.bof_upload.cache.content["step1.5"])[0] == window.bof_upload.cache["step1.5"] )
          $(document).find("#uploader .step5").addClass("step1_5_group");
        }

        var promisetoRenderItems = [];
        var items = window.bof_upload.cache["verified"];
        for ( var i=0; i<items.length; i++ ){

          var item = items[i];
          var promiseToRenderItem = $.Deferred();
          var promiseToRenderInputs = [];

          if ( item.groups ? item.groups.length : false ){
            var promiseToRenderGroup = $.Deferred();
            var group_html = "<div class='groups_wrapper'>";
            for ( var z=0; z<item.groups.length; z++ ){

              var _ig = item.groups[z];
              var _igCode = _ig[0];
              var _igLabel = _ig[1];

              group_html += "<div class='group"+(z==0?" active":"")+"' data-code='"+_igCode+"'>"+ _igLabel +"</div>";

            }
            group_html += "</div>";
            promiseToRenderGroup.resolve( group_html );
            promiseToRenderInputs.push( promiseToRenderGroup );
          }

          for ( var z=0; z<Object.keys(item["inputs"]).length; z++ ){

            var promiseToRenderInput = $.Deferred();
            promiseToRenderInputs.push( promiseToRenderInput );

            var item_ik = Object.keys(item["inputs"])[z];
            var item_iv = item["inputs"][item_ik];
            var item_of_first_group = item_iv.group ? item_iv.group == "all" || item_iv.group == item.groups[0][0] : true;

            window.ui.theme.part( "parts/o_input", { target: false, dir: "theme", base: $_bof_config.assets_address } ).done(function( html ){
              window.render.mix( html, item_iv.input ).done(function( renderred ){
                promiseToRenderInput.resolve(
                  "<div class='input_wrapper type_"+item_iv.input.type+" group_"+(item_iv.group?item_iv.group:"all")+" setting_wrapper"+(item_of_first_group?"":" hideByGroup")+(item_iv.hideStep1_5?" hideByStep":"")+"' ID='item_"+item_iv.input.name+"'>"+
                    "<div class='title'>"+
                      item_iv.label +
                    "</div>" +
                    "<div class='the_input'>" +
                      renderred +
                    "</div>" +
                    ( item_iv.tip ? "<div class='tip'>" + item_iv.tip + "</div>" : "" ) +
                  "</div>"
                );
              } );
            } );

          }

          $.when.apply( $, promiseToRenderInputs ).done(function(){
            var inputs_renderred = Array.prototype.slice.call( arguments, 0 );
            promiseToRenderItem.resolve( "<div class='form_wrapper uef' data-id='"+item.ID+"'>\
              <div class='s_title'>"+item.data.s_title+"</div>\
              <form><div class='inputs_wrapper'>"+ inputs_renderred.join("") +"</div></form>\
              <div class='continue'><div class='btn btn-primary' data-form-id='"+item.ID+"'>"+window.lang.return( "save", { ucfirst: true } )+"</div></div>\
              </div>" );
          });

          promisetoRenderItems.push( promiseToRenderItem );

        }

        $.when.apply( $, promisetoRenderItems ).done(function(){
          var items_renderred = Array.prototype.slice.call( arguments, 0 );
          $(document).find("#uploader .step5").html( items_renderred.join("") );
          window.bof_input.hook_daterangepicker()
          window.ui.lock.off("upload_step_4");
          window.bof_upload.functions.exe_rules( $(document).find("#uploader .step5 .form_wrapper") );
        });

      }

    },
    exe_rules: function( $formDom ){
      for ( var i=0; i<window.bof_upload.cache["verified"].length; i++ ){
        var f = window.bof_upload.cache["verified"][i];
        if ( f.ID == $formDom.attr("data-id") ){
          window.bof_input.exe_display_rules( f.inputs );
        }
      }
    },
    dropzone_setup: function(){

      $(document).find("#uploader .source_dom").html(
        "<div class='uploader_wrapper virgin'>\
          <div class='uploader_mask file' ID='the_dom'>\
            <span class='mdi mdi-cloud-upload'></span>\
            <span class='text'>"+window.lang.return( "upload_dragdrop", { ucfirst: true } )+"</span>\
            <span class='sub_text'>"+window.lang.return( "upload_click", { ucfirst: true } )+". <span class='_rules'>"+window.lang.return( "upload_rules", { ucfirst: true } )+"</span></span>\
            <span class='tip'>"+ window.bof_upload.cache.source.upload.inputs.file.tip +"</span>\
            <div class='progress_text'></div>\
            <div class='progress'><div class='e'></div></div>\
            <div class='continue'><div class='btn btn-primary'>"+window.lang.return( "continue", { ucfirst: true } )+"</div></div>\
          </div>\
          <div class='uploader_progress'></div>\
        </div>"
      );

      window.bof_input.dropzone_start( "the_dom", $.extend( window.bof_upload.cache.source.upload.inputs.file.input, {
        type: window.bof_upload.cache.source.upload.inputs.file.bofInput[1].type,
        object_type: window.bof_upload.cache.source.upload.inputs.file.bofInput[1].object_type
      } ), {
        init: function(){
          window.bof_upload.functions.dropzone_manager( this, window.bof_upload.cache.source.upload.inputs.file.input, "the_dom" );
          window.ui.lock.off("upload_source");
        },
        clickable: [ "#uploader .uploader_mask", "#uploader .uploader_mask > span" ],
        previewsContainer: "#uploader .uploader_progress",
        createImageThumbnails: true,
        previewTemplate: '<div class="preview">\
                            <div class="sta">\
                              <span class="pending mdi mdi-progress-clock"></span>\
                              <span class="processing mdi mdi-refresh"></span>\
                              <span class="done mdi mdi-progress-check"></span>\
                              <span class="failed mdi mdi-progress-alert"></span>\
                            </div>\
                            <div class="detail dz-details">\
                              <div class="filename"><span data-dz-name></span></div>\
                              <div class="size" data-dz-size></div>\
                            </div>\
                            <div class="progress">\
                              <span class="progress_e" data-dz-uploadprogress></span>\
                            </div>\
                            <div class="error"><span data-dz-errormessage></span></div>\
                          </div>'
      } );

    },
    dropzone_manager: function( myDropzone, setting, ID ){

      myDropzone.on("sending", function(file,xhr) {
        window.becli.sign( xhr );
      });

      myDropzone.on("uploadprogress", function(file){
        window.bof_upload.functions.dropzone_progress( this, "uploadprogress", ID );
      });

      myDropzone.on("complete", function(){
        window.bof_upload.functions.dropzone_progress( this, "complete", ID );
      });

      myDropzone.on("addedfile", function(){
        $(document).find("#uploader .uploader_wrapper").removeClass("virgin done");
        $(document).find("#uploader .step.source_dom .uploader_mask").removeClass("show_tip");
      });

    },
    dropzone_progress: function( myDropzone, eventName, ID ){

      var report = window.bof_input.dropzone_report( myDropzone );

      if ( report.progress != window.bof_upload.cache.progress ||
           report._allDone != window.bof_upload.cache.all_done ){

        window.bof_upload.cache.progress = report.progress;
        window.bof_upload.cache.all_done = report._allDone;

        $(document).find("#uploader .uploader_mask .progress .e").css( "width", report.progress + "%" )
        $(document).find("#uploader .uploader_mask .progress_text").html( "<span>" + report.total_files + " " +window.lang.return(report.total_files==1?"file":"files")+( report.total_fail ? ", " + report.total_fail + " failed" : "" )+"</span>" +
        "<span>" + window._g.humanFileSize( report.total_size_uped ) + " / " + window._g.humanFileSize( report.total_size ) + "</span>" )

        if ( report._allDone ){
          $(document).find("#uploader .uploader_wrapper").addClass("done");
        }

      }

    },
    dropzone_check: function( sta, data, ID ){

      if ( sta ? data.messages[0] == "done" : false ){
        console.log("OK");
      }
      else {
        console.log("FAILED");
      }

    },
  }

}
